(function ($) {
    'use strict';

    var url_action;
    var url_view;

    //ajax login
    $('#formUserLogin').submit(function (e) {
        e.preventDefault();
        var values = $(this).serialize();
        $.ajax({
            method: 'POST',
            url: settings.PathSystem + 'admin/ajax/login',
            data: values,
            dataType: 'json',
            beforeSend: function () {
                $('#display-btn-login').css('display', 'none');
                $('#login-load').css('display', 'block');
            },
            success: function (i) {
                if (i.status == 'success') {
                    $('#login-valid').html(i.title + '!');
                    window.location.href = settings.PathSystem + 'admin/dashboard';
                } else {
                    $('#display-btn-login').css('display', 'block');
                    $('#login-load').css('display', 'none');
                    $.notify(
                        {
                            icon: 'fa fa-times',
                            title: i.title,
                            message: i.msg
                        },
                        {
                            type: 'danger'
                        }
                    );
                }
            }
        });
    });

    $('#formUserRecovery').submit(function (e) {
        var formID = '#formUserRecovery';
        e.preventDefault();
        var data = new FormData(this);
        data.append('action', 'checkemail');
        $.ajax({
            method: 'POST',
            url: settings.PathSystem + 'admin/ajax/recovery',
            data: data,
            dataType: 'json',
            processData: false,
            contentType: false,
            cache: false,
            beforeSend: function () {
                $(formID + ' #display-btn-login').css('display', 'none');
                $(formID + ' #login-load').css('display', 'block');
            },
            success: function (i) {
                $(formID + ' #display-btn-login').css('display', 'block');
                $(formID + ' #login-load').css('display', 'none');
                if (i.status == 'success') {
                    $('#modalVerify').modal('show');
                } else {
                    $.notify(
                        {
                            icon: 'fa fa-times',
                            title: i.title,
                            message: i.msg
                        },
                        {
                            type: 'danger'
                        }
                    );
                }
            }
        });
    });

    $('#formUserCodeVerify').submit(function (e) {
        var formID = '#formUserCodeVerify';
        e.preventDefault();
        var data = new FormData(this);
        data.append('action', 'codeverify');
        $.ajax({
            method: 'POST',
            url: settings.PathSystem + 'admin/ajax/recovery',
            data: data,
            dataType: 'json',
            processData: false,
            contentType: false,
            cache: false,
            beforeSend: function () {
                $(formID + ' .display-btn-login').css('display', 'none');
                $(formID + ' .login-load').css('display', 'block');
            },
            success: function (i) {
                $(formID + ' .display-btn-login').css('display', 'block');
                $(formID + ' .login-load').css('display', 'none');

                if (i.status == 'success') {
                    $('#modalVerify').modal('hide');
                    window.location.reload();
                } else {
                    if (i.data.codeAttempts) {
                        $('#modalVerify').modal('hide');
                    }
                    $.notify(
                        {
                            icon: 'fa fa-times',
                            title: i.title,
                            message: i.msg
                        },
                        {
                            type: 'danger',
                            z_index: 1080
                        }
                    );
                }
                $('#code_verify').val('');
            }
        });
    });

    $('#formUserPassReset').submit(function (e) {
        var formID = '#formUserPassReset';
        e.preventDefault();
        var data = new FormData(this);
        data.append('action', 'changepass');
        $.ajax({
            method: 'POST',
            url: settings.PathSystem + 'admin/ajax/recovery',
            data: data,
            dataType: 'json',
            processData: false,
            contentType: false,
            cache: false,
            beforeSend: function () {
                $(formID + ' .display-btn-login').css('display', 'none');
                $(formID + ' .login-load').css('display', 'block');
            },
            success: function (i) {
                $(formID + ' .display-btn-login').css('display', 'block');
                $(formID + ' .login-load').css('display', 'none');

                if (i.status == 'success') {
                    window.location.href = settings.PathSystem + 'admin/login';
                } else {
                    $.notify(
                        {
                            icon: 'fa fa-times',
                            title: i.title,
                            message: i.msg
                        },
                        {
                            type: 'danger',
                            z_index: 1080
                        }
                    );
                }
            }
        });
    });

    //submit license
    $('#formLicense').submit(function (e) {
        e.preventDefault();
        var values = $(this).serialize();
        $.ajax({
            method: 'POST',
            url: settings.PathSystem + 'admin/license',
            data: values,
            dataType: 'json',
            beforeSend: function () {
                $('#display-btn-login').css('display', 'none');
                $('#login-load').css('display', 'block');
                $('#licensekey').removeClass('is-invalid').removeClass('text-danger');
                $('#text-error').html('');
            },
            success: function (i) {
                if (i.status == 'success') {
                    $('#login-valid').html(i.title + '!');
                    $('#licensekey').addClass('is-valid').addClass('text-success');
                    window.location.href = settings.PathSystem + 'admin';
                } else {
                    $('#display-btn-login').css('display', 'block');
                    $('#login-load').css('display', 'none');
                    $('#text-error').html(i.msg);
                    $('#licensekey').addClass('is-invalid').addClass('text-danger');
                    $.notify(
                        {
                            icon: 'fa fa-lock',
                            //title: i.title,
                            message: '<b class="text-dark">' + i.msg + '</b>'
                        },
                        {
                            type: 'danger'
                        }
                    );
                }
            }
        });
    });

    $('.setting-submit').click(function (e) {
        e.preventDefault();
        $(this).addClass('d-none');
        $(this.closest('div')).children('.setting-submit-load').addClass('d-block');
        var form = $(this.closest('form'));
        var reportValidity = form[0].reportValidity();
        if (reportValidity) {
            form.submit();
        } else {
            $(this).removeClass('d-none');
            $(this.closest('div')).children('.setting-submit-load').removeClass('d-block');
        }
    });

    function updateCheck() {
        if ($('.wrapper-login').length == 0) {
            var d = new Date();
            var day = d.getDate();
            var month = d.getMonth() + 1;
            var year = d.getFullYear();
            var hour = d.getHours();
            var minute = d.getMinutes();
            var second = d.getSeconds();
            if (month.toString().length < 2) month = '0' + month;
            if (day.toString().length < 2) day = '0' + day;
            if (hour.toString().length < 2) hour = '0' + hour;
            if (minute.toString().length < 2) minute = '0' + minute;
            if (second.toString().length < 2) second = '0' + second;

            var datetime = `${year}-${month}-${day} ${hour}:${minute}:${second}`;
            if (datetime > settings.next_update_check) {
                console.log('success');
                $.ajax({
                    method: 'POST',
                    url: settings.PathSystem + 'admin/ajax/update_system',
                    data: { update_now: '' },
                    dataType: 'json'
                });
            }
        }
    }

    function setupWizard() {
        if (settings.setupWizard == 0 && settings.level == 1) {
            if (settings.Page2 == 'dashboard') {
                $.ajax({
                    url: '/admin/wizard',
                    method: 'GET',
                    dataType: 'html',
                    success: function (i) {
                        $('#view_result').html(i);
                        $('#viewModal').modal('show');
                    }
                });
            }
        }
    }

    function set_user_last_seen() {
        if ($('.wrapper-login').length == 0) {
            $.ajax({
                url: settings.PathSystem + 'admin/ajax/set_last_seen',
                method: 'POST',
                dataType: 'json'
            });
        }
    }

    function cropImageModal() {
        let instance = '';
        let openNewModal = 'true';
        let imgw = '';
        let imgh = '';
        let imgCrop = '';
        let imgPrev = '';
        let modalView = $('#viewModal');
        let modalCrop = $('#modal-crop');
        $(document).on('change', '.crop-image-modal', function (e) {
            // button
            $('.btn-crop-submit').removeClass('d-none');
            $('#btn-crop-cancel').removeClass('d-none');
            $('#crop-load').removeClass('d-block');

            // vars
            imgPrev = document.querySelector('#modal-crop #image');
            imgw = Number($(this).attr('data-imgw'));
            imgh = Number($(this).attr('data-imgh'));
            instance = $(this).attr('data-instance');
            openNewModal = $(this).attr('data-newmodal');
            modalView = $(this).attr('data-modalview')
                ? $('#' + $(this).attr('data-modalview'))
                : modalView;

            imgCrop = document.getElementById('crop-instance-' + instance);

            let cropper = [];
            let input = this;

            if (input.files && input.files[0]) {
                let reader = new FileReader();
                reader.onload = function (e) {
                    imgPrev.src = e.target.result;
                    if (openNewModal == 'true') {
                        modalView.modal('hide');
                    }

                    modalCrop.modal('show');
                };
                reader.readAsDataURL(input.files[0]);
            }

            $('#crop').click(function () {
                // button crop
                $('.btn-crop-submit').addClass('d-none');
                $('#btn-crop-cancel').addClass('d-none');
                $('#crop-load').addClass('d-block');
                $('#cropclick').attr('value', 1);

                // result
                if (cropper[instance]) {
                    let canvas = cropper[instance].getCroppedCanvas({ width: imgw, height: imgh });
                    imgCrop.src = canvas.toDataURL();
                }
                modalCrop.modal('hide');
            });

            modalCrop
                .on('shown.bs.modal', function () {
                    cropper[instance] = new Cropper(imgPrev, {
                        aspectRatio: imgw / imgh,
                        viewMode: 2,
                        movable: true,
                        zoomable: true,
                        rotate: 0,
                        rotatable: false,
                        scalable: false,
                        autoCropArea: 1,
                        crop: function (e) {
                            $('#x').val(e.detail.x);
                            $('#y').val(e.detail.y);
                            $('#w').val(e.detail.width);
                            $('#h').val(e.detail.height);
                        },
                        ready: function () {
                            $('body').addClass('modal-open');
                        }
                    });
                })
                .on('hidden.bs.modal', function () {
                    // check crop
                    let cropclick = $('#cropclick').attr('value');
                    cropclick == 0 ? (input.value = '') : '';
                    //destroy
                    cropper[instance].destroy();
                    cropper[instance] = null;
                    if (openNewModal == 'true') {
                        modalView.modal('show');
                    }
                });
        });
    }

    //submit page view - add e edit
    function submit_form(url_action) {
        $('#formPostSubmit').submit(function (e) {
            e.preventDefault();
            var values = new FormData(this);
            $.ajax({
                url: url_action,
                method: 'POST',
                data: values,
                dataType: 'json',
                mimeType: 'multipart/form-data',
                processData: false,
                contentType: false,
                cache: false,
                beforeSend: function (xhr) {
                    $('#btn-form-submit').addClass('d-none');
                    $('#btn-form-cancel').addClass('d-none');
                    $('#submit-load').addClass('d-block');
                },
                success: function (ii) {
                    //console.log(ii)
                    if (ii.status == 'success') {
                        location.href = '../manage';
                    } else {
                        $('#btn-form-submit').removeClass('d-none');
                        $('#btn-form-cancel').removeClass('d-none');
                        $('#submit-load').removeClass('d-block');
                    }
                }
            });
        });
    }

    //submit modal view - add e edit
    function submit_modal(url_action, reload_datatable, refresh) {
        $('#formPost').submit(function (e) {
            e.preventDefault();
            var values = new FormData(this);
            $.ajax({
                url: url_action,
                method: 'POST',
                data: values,
                dataType: 'json',
                mimeType: 'multipart/form-data',
                processData: false,
                contentType: false,
                cache: false,
                beforeSend: function (xhr) {
                    $('#btn-form-submit').addClass('d-none');
                    $('#btn-form-cancel').addClass('d-none');
                    $('#submit-load').addClass('d-block');
                },
                success: function (ii) {
                    if (ii.status == 'success') {
                        $('#viewModal').modal('hide');
                        if (reload_datatable == true) {
                            dataTable.ajax.reload(null, false);
                        }
                        if (refresh) {
                            document.location.reload();
                        }
                    } else {
                        $('#btn-form-submit').removeClass('d-none');
                        $('#btn-form-cancel').removeClass('d-none');
                        $('#submit-load').removeClass('d-block');
                    }
                    if (ii.title || ii.msg) {
                        $.notify(
                            {
                                icon: ii.icon,
                                title: ii.title,
                                message: ii.msg
                            },
                            {
                                type: ii.type,
                                z_index: 20000
                            }
                        );
                    }
                }
            });
        });
    }

    //view modal - add e edit
    function click_modal_view(ref, url_view, submit, url_action, reload_datatable, refresh) {
        $(document).on('click', ref, function (e) {
            e.preventDefault();
            var id = $(this).attr('id');
            var data_url = $(this).attr('data-url');
            var title = $(this).attr('data-original-title');
            var url_ajax = url_view + data_url;
            $('.click_action, .click_action_refresh').tooltip('hide');

            $.ajax({
                url: url_ajax,
                method: 'POST',
                data: { id: id },
                success: function (i) {
                    let res = {};
                    try {
                        res = JSON.parse(i);
                    } catch (e) {}
                    //permissão
                    if (res.status != 'error') {
                        $('#title_modal').html(title);
                        $('#view_result').html(i);
                        $('#viewModal').modal('show');
                        if (submit == true) {
                            submit_modal(url_action, reload_datatable, refresh);
                        }
                    } else {
                        $('#viewModal').modal('hide');
                        $.notify(
                            {
                                icon: res.icon,
                                title: res.title,
                                message: res.msg
                            },
                            {
                                type: res.type,
                                z_index: 20000
                            }
                        );
                    }
                }
            });
        });
    }

    //delete item
    function click_delete(ref, url_action, refresh) {
        $(document).on('click', ref, function (e) {
            e.preventDefault();
            swal({
                icon: 'warning',
                title: lang.are_sure,
                text: lang.not_undo_this,
                type: 'warning',
                buttons: {
                    confirm: { text: lang.delete_yes, className: 'btn btn-success' },
                    cancel: { visible: true, text: lang.cancel, className: 'btn btn-danger' }
                }
            }).then((Delete) => {
                if (Delete) {
                    var id = $(this).attr('id');
                    var action = $(this).attr('action');
                    if (!action) {
                        var action = 'delete';
                    }
                    $.ajax({
                        url: url_action,
                        method: 'POST',
                        dataType: 'json',
                        data: { id: id, action: action },
                        success: function (i) {
                            if (i.status == 'success') {
                                if (refresh) {
                                    document.location.reload();
                                } else {
                                    dataTable.ajax.reload(null, false);
                                }
                            }
                            swal({
                                icon: i.status,
                                title: i.title,
                                text: i.msg,
                                type: i.type,
                                buttons: { confirm: { className: 'btn btn-success' } }
                            });
                        }
                    });
                } else {
                    swal.close();
                }
            });
        });
    }

    //Ajax click action
    function click_action(ref, url_action, notify, reload_datatable) {
        $(document).on('click', ref, function (e) {
            e.preventDefault();
            var id = $(this).attr('id');
            var action = $(this).attr('action');
            console.log(action);
            $.ajax({
                url: url_action,
                method: 'POST',
                dataType: 'json',
                data: { id: id, action: action },
                success: function (data) {
                    if (data.status == 'success') {
                        if (reload_datatable == true) {
                            dataTable.ajax.reload(null, false);
                        }
                    }
                    if (notify == true) {
                        $.notify(
                            {
                                icon: data.icon,
                                title: data.title,
                                message: data.msg
                            },
                            { type: data.type }
                        );
                    }
                }
            });
        });
    }

    function layoutsColors() {
        $('.sidebar').is('[data-background-color]')
            ? $('html').addClass('sidebar-color')
            : $('html').removeClass('sidebar-color'),
            $('body').is('[data-image]')
                ? $('body').css('background-image', 'url("' + $('body').attr('data-image') + '")')
                : $('body').css('background-image', '');
    }

    function legendClickCallback(a) {
        for (var e = (a = a || window.event).target || a.srcElement; 'LI' !== e.nodeName; )
            e = e.parentElement;
        var s = e.parentElement,
            o = parseInt(s.classList[0].split('-')[0], 10),
            i = Chart.instances[o],
            n = Array.prototype.slice.call(s.children).indexOf(e);
        i.legend.options.onClick.call(i, a, i.legend.legendItems[n]),
            i.isDatasetVisible(n) ? e.classList.remove('hidden') : e.classList.add('hidden');
    }

    function readURL(a) {
        if (a.files && a.files[0]) {
            var e = new FileReader();
            (e.onload = function (e) {
                $(a)
                    .parent('.input-file-image')
                    .find('.img-upload-preview')
                    .attr('src', e.target.result);
            }),
                e.readAsDataURL(a.files[0]);
        }
    }

    function showPassword(a) {
        var e = $(a).parent().find('input');
        'password' === e.attr('type') ? e.attr('type', 'text') : e.attr('type', 'password');
    }

    function changeContainer() {
        1 == showSignIn
            ? containerSignIn.css('display', 'block')
            : containerSignIn.css('display', 'none'),
            1 == showSignUp
                ? containerSignUp.css('display', 'block')
                : containerSignUp.css('display', 'none');
    }

    $('.nav-search .input-group > input')
        .focus(function (a) {
            $(this).parent().addClass('focus');
        })
        .blur(function (a) {
            $(this).parent().removeClass('focus');
        }),
        $(function () {
            $('[data-toggle="tooltip"]').tooltip(),
                $('[data-toggle="popover"]').popover(),
                layoutsColors();
        }),
        $(document).ready(function () {
            $('.btn-refresh-card').on('click', function () {
                var a = $(this).parents('.card');
                a.length &&
                    (a.addClass('is-loading'),
                    setTimeout(function () {
                        a.removeClass('is-loading');
                    }, 3e3));
            });
            var a = $('.sidebar .scrollbar');
            a.length > 0 && a.scrollbar();
            var e = $('.main-panel .content-scroll');
            e.length > 0 && e.scrollbar();
            var s = $('.messages-scroll');
            s.length > 0 && s.scrollbar();
            var o = $('.tasks-scroll');
            o.length > 0 && o.scrollbar();
            var i = $('.quick-scroll');
            i.length > 0 && i.scrollbar();
            var n = $('.message-notif-scroll');
            n.length > 0 && n.scrollbar();
            var r = $('.notif-scroll');
            r.length > 0 && r.scrollbar();
            var l = $('.quick-actions-scroll');
            l.length > 0 && l.scrollbar();
            var t = $('.dropdown-user-scroll');
            t.length > 0 && t.scrollbar(),
                $('.scroll-bar').draggable(),
                $('#search-nav').on('shown.bs.collapse', function () {
                    $('.nav-search .form-control').focus();
                });
            var c = !1,
                d = !1,
                g = !1,
                p = !1,
                h = 0,
                m = 0,
                u = 0,
                v = 0,
                f = 0,
                b = 0;
            if (!c) {
                (C = $('.sidenav-toggler')).on('click', function () {
                    1 == h
                        ? ($('html').removeClass('nav_open'), C.removeClass('toggled'), (h = 0))
                        : ($('html').addClass('nav_open'), C.addClass('toggled'), (h = 1));
                }),
                    (c = !0);
            }
            if (!m) {
                var C = $('.quick-sidebar-toggler');
                C.on('click', function () {
                    1 == h
                        ? ($('html').removeClass('quick_sidebar_open'),
                          $('.quick-sidebar-overlay').remove(),
                          C.removeClass('toggled'),
                          (m = 0))
                        : ($('html').addClass('quick_sidebar_open'),
                          C.addClass('toggled'),
                          $('<div class="quick-sidebar-overlay"></div>').insertAfter(
                              '.quick-sidebar'
                          ),
                          (m = 1));
                }),
                    $('.wrapper').mouseup(function (a) {
                        var e = $('.quick-sidebar');
                        a.target.className == e.attr('class') ||
                            e.has(a.target).length ||
                            ($('html').removeClass('quick_sidebar_open'),
                            $('.quick-sidebar-toggler').removeClass('toggled'),
                            $('.quick-sidebar-overlay').remove(),
                            (m = 0));
                    }),
                    $('.close-quick-sidebar').on('click', function () {
                        $('html').removeClass('quick_sidebar_open'),
                            $('.quick-sidebar-toggler').removeClass('toggled'),
                            $('.quick-sidebar-overlay').remove(),
                            (m = 0);
                    }),
                    (m = !0);
            }
            if (!d) {
                var w = $('.topbar-toggler');
                w.on('click', function () {
                    1 == u
                        ? ($('html').removeClass('topbar_open'), w.removeClass('toggled'), (u = 0))
                        : ($('html').addClass('topbar_open'), w.addClass('toggled'), (u = 1));
                }),
                    (d = !0);
            }
            if (!g) {
                var k = $('.toggle-sidebar');
                $('.wrapper').hasClass('sidebar_minimize') &&
                    ((v = 1),
                    k.addClass('toggled'),
                    k.html('<i class="icon-options-vertical"></i>')),
                    k.on('click', function () {
                        1 == v
                            ? ($('.wrapper').removeClass('sidebar_minimize'),
                              k.removeClass('toggled'),
                              k.html('<i class="icon-menu"></i>'),
                              (v = 0))
                            : ($('.wrapper').addClass('sidebar_minimize'),
                              k.addClass('toggled'),
                              k.html('<i class="icon-options-vertical"></i>'),
                              (v = 1)),
                            $(window).resize();
                    }),
                    (g = !0);
            }
            if (!p) {
                var _ = $('.page-sidebar-toggler');
                _.on('click', function () {
                    1 == f
                        ? ($('html').removeClass('pagesidebar_open'),
                          _.removeClass('toggled'),
                          (f = 0))
                        : ($('html').addClass('pagesidebar_open'), _.addClass('toggled'), (f = 1));
                });
                $('.page-sidebar .back').on('click', function () {
                    $('html').removeClass('pagesidebar_open'), _.removeClass('toggled'), (f = 0);
                }),
                    (p = !0);
            }
            var y = $('.sidenav-overlay-toggler');
            $('.wrapper').hasClass('is-show') &&
                ((b = 1), y.addClass('toggled'), y.html('<i class="icon-options-vertical"></i>')),
                y.on('click', function () {
                    1 == b
                        ? ($('.wrapper').removeClass('is-show'),
                          y.removeClass('toggled'),
                          y.html('<i class="icon-menu"></i>'),
                          (b = 0))
                        : ($('.wrapper').addClass('is-show'),
                          y.addClass('toggled'),
                          y.html('<i class="icon-options-vertical"></i>'),
                          (b = 1)),
                        $(window).resize();
                }),
                (g = !0),
                $('.sidebar').hover(
                    function () {
                        $('.wrapper').hasClass('sidebar_minimize') &&
                            $('.wrapper').addClass('sidebar_minimize_hover');
                    },
                    function () {
                        $('.wrapper').hasClass('sidebar_minimize') &&
                            $('.wrapper').removeClass('sidebar_minimize_hover');
                    }
                ),
                $('.nav-item a').on('click', function () {
                    $(this).parent().find('.collapse').hasClass('show')
                        ? $(this).parent().removeClass('submenu')
                        : $(this).parent().addClass('submenu');
                }),
                $('.messages-contact .user a').on('click', function () {
                    $('.tab-chat').addClass('show-chat');
                }),
                $('.messages-wrapper .return').on('click', function () {
                    $('.tab-chat').removeClass('show-chat');
                }),
                $('[data-select="checkbox"]').change(function () {
                    var a = $(this).attr('data-target');
                    $(a).prop('checked', $(this).prop('checked'));
                }),
                $('.form-group-default .form-control')
                    .focus(function () {
                        $(this).parent().addClass('active');
                    })
                    .blur(function () {
                        $(this).parent().removeClass('active');
                    });
        }),
        $('.input-file-image input[type="file"').change(function () {
            readURL(this);
        }),
        $('.show-password').on('click', function () {
            showPassword(this);
        });
    var containerSignIn = $('.container-login'),
        containerSignUp = $('.container-signup'),
        showSignIn = !0,
        showSignUp = !1;
    $('#show-signup').on('click', function () {
        (showSignUp = !0), (showSignIn = !1), changeContainer();
    }),
        $('#show-signin').on('click', function () {
            (showSignUp = !1), (showSignIn = !0), changeContainer();
        }),
        changeContainer(),
        $('.form-floating-label .form-control').keyup(function () {
            '' !== $(this).val() ? $(this).addClass('filled') : $(this).removeClass('filled');
        });

    //get urls
    if (
        settings.Page4 == '' ||
        settings.Page3 == 'manage' ||
        settings.Page3 == 'edit' ||
        settings.Page3 == 'add'
    ) {
        var url_view = settings.PathSystem + 'admin/' + settings.Page2 + '/';
        var url_action = url_view + 'actions';
    } else {
        var url_view = settings.PathSystem + 'admin/' + settings.Page2 + '/' + settings.Page3 + '/';
        var url_action = url_view + 'actions';
    }

    submit_form(url_action);

    //alterar status
    click_action('.change_status', url_action, true, true);

    //excluir item
    click_delete('.delete_item', url_action);
    click_delete('.delete_item_refresh', url_action, true);

    //click action item
    click_modal_view('.click_action', url_view, true, url_action, true, false);
    click_modal_view('.click_action_refresh', url_view, true, url_action, false, true);

    //quick_actions
    click_modal_view(
        '#profile_edit',
        settings.PathSystem + 'admin/profile_edit',
        true,
        settings.PathSystem + 'admin/ajax/profile_edit',
        false,
        false
    );

    //click_action('.read_notify', settings.URLAjax+'read_notify.php', false);

    //visto por ultimo
    set_user_last_seen();
    setInterval(function () {
        set_user_last_seen();
    }, 270000);

    setupWizard();
    updateCheck();
    cropImageModal();
})(jQuery);
